  CONSTRUCTION OF THE CONSUMPTION EXPENDITURE AGGREGATE FOR THE IFLS-EAST 2012  
*********************************************************************************
* Dataset: IFLS East 2012
* Authors: Mercoledi Nikman Nasiir, Jan Priebe, Firman Witoelar
* Date of this version  : 8 January 2014
*********************************************************************************

clear

set more off

capture log close

global drive "D:"			// Specify Main Drive
global dir "\xxx"			// Specify Directory of IFLS East 2012
global rawdata "\xxx"		// Specify folder name of IFLS East 2012 data
local path $drive$dir
cap mkdir "`path'\temp"		// Automatically create new folder called temp in directory
global dir0 "`path'\temp"
cd "`path'\temp"
log using "$dir0\pce_ifle", text replace

clear

set more off

capture log close

global drive "D:"			// specify drive
global dir "\xxx"			// specify directory of IFLS East 2012
global rawdata "\xxx"		// specify folder name of IFLS East 2012 data
local path $drive$dir
cap mkdir "`path'\temp"		// automatically create new folder called temp in directory
global dir0 "`path'\temp"
cd "`path'\temp"
log using "$dir0\pce_ifle", text replace

**************************************************************************** 
* Folders used:
*	`path'\temp		// for putting temporary files, can be deleted later
*	`path'\
* Files used:  
*   Original files: bk_sc.dta, bk_ar1.dta, b1_ks0.dta, b1_ks1.dta, b1_ks2.dta, b2_kr.dta  
* Files created:  
*   percapita_expenditure_iflse2012.dta  
****************************************************************************  
set more off 
set trace off 
set matsize 300 

****************************************************************************  
* GENERAL NOTES 
****************************************************************************  
*Interquartile range analyis showed that the following vars had more than 50 outliers so manual cleaning was applied 
*Variables are: 
/*
kr04 -> based on visual inspection: do nothing
kr05 -> based on visual inspection: do nothing
ks06 -> based on visual inspection: do nothing
ks08 -> manual cleaning applied
	ks08A: censor every single observation above Rp10million
	ks08B: censor every single observation above Rp10million
	ks08C: censor every single observation above Rp15million
	ks08D: censor every single observation above Rp15million
	ks08E: censor every single observation above Rp10million
	ks08F: do nothing
	ks08G: censor every single observation above Rp20million
ks09 -> 167 obs
	ks09aA-ks09aF: do nothing as values are considered to be plausible
ks10aa -> censor every single observation above Rp15million
ks11aa -> one obs reporting 20,600,000, considered as outlier and regarded missing
ks12aa -> censor every single observation above Rp20million
*/


****************************************************************************  
* I. Create a file with kecamatan ID, kabupaten ID, etc  
****************************************************************************  

use hhid12 commid12 sc01* sc02* sc03* sc05*  using $rawdata\bk_sc, clear 
bys commid12: gen n_comm=_N
gen str5 kec = string(sc02,"%02.0f") + string(sc03,"%03.0f")
bys kec: gen n_kec=_N 
 
 bysort hhid12: keep if _n==_N 
 gen provid_east=sc01 
 gen double kabid=sc01*100+sc02 
 gen double kecid=(kabid*1000)+sc03 
  sort hhid12 
 gen rural=(sc05!=1) 
 sort hhid12 
save $dir0\sc_east, replace  

**************************************************************************** 
* II. Housing Expenditures, Book KR (B2_KR.DTA)  
****************************************************************************
* II.1 Identify outliers 
****************************************************************************  
use hhid12 kr03 kr04* kr05* using  $rawdata\b2_kr, clear  
bys hhid12: keep if _n==_N 
format kr04a kr05a %12.0f  
tab1 kr04a kr05a  
sort hhid12  

gen kr04=kr04a if kr04ax==2 
replace kr04=kr04a/12 if kr04ax==1 

gen kr05=kr05a if kr05ax==2 
replace kr05=kr05a/12 if kr05ax==1 

save $dir0\tempkr_east, replace  

* II.2 Merge with kecid, kabid, information  
****************************************************************************  
use $dir0\sc_east, clear  
sort hhid12  
merge 1:1 hhid12 using $dir0\tempkr_east 
tab _merge  
*Only keep HHs who answered Book 2  
keep if _merge==3  
drop _merge  

tab kr04ax  
tab kr05ax  

* II.3 Generate median variables   
****************************************************************************  
egen medcom05a=median(kr05), by(commid12)  
egen medkec05a=median(kr05), by(kecid)  
egen medkab05a=median(kr05), by(kabid)  

egen medcom04a=median(kr04)  
egen medkec04a=median(kr04), by(kecid)  
egen medkab04a=median(kr04), by(kabid)  
compress  


* II.4. Imputation  
****************************************************************************  
rename kr04 origkr04  
rename kr05 origkr05  

gen kr04=origkr04 if kr04ax!=. & origkr04!=.  
replace kr04=medcom04a if kr04ax!=. & origkr04==.  
replace kr04=medkec04a if kr04ax!=. & kr04==.  
replace kr04=medkec04a if n_comm==1 & kr04ax!=. & kr04==.  
replace kr04=medkab04a if kr04ax!=. & kr04==.  
replace kr04=medkab04a if n_kec==1 & kr04ax!=. & kr04==.  

gen kr05=origkr05 if kr05ax!=. & origkr05!=.  
replace kr05=medcom05a if kr05ax!=. & origkr05==.  
replace kr05=medkec05a if kr05ax!=. & kr05==.  
replace kr05=medkec05a if n_comm==1 & kr05ax!=. & kr05==.  
replace kr05=medkab05a if kr05ax!=. & kr05==.  
replace kr05=medkab05a if n_kec==1 & kr05ax!=. & kr05==.  
extremes kr05, hi n(20)
gen  owners=(kr05ax!=.)  
lab define owners 1 "Owners" 0 "Renters"  
lab value owners owners  
lab var owners "Owners or renters?"  


* II.5 Generate variable containing information on missing values in this data file   
****************************************************************************  
gen misskr=1 if kr04==. & kr04ax!=.  
replace misskr=1 if kr05==. & kr05ax!=.  
replace misskr=0 if misskr==.  
lab var misskr "Household with missng kr04 or kr05"  
tab misskr, m  

* II.6 Label, compress, sort, and save the data  
****************************************************************************  
lab data "KR with imputed values"  
compress  
sort hhid12   
capture drop med* origk*  
save $dir0\b2_kr_east, replace  
keep hhid12 kr04 kr05
tempfile 3 
save `3' 

************************************************************************  
* III. Book 1 - KS  Food Consumption: KS02, KS03  
************************************************************************  
* III.1 Identify outliers  
****************************************************************************  
use hhid12 ks02 ks03 id_ks1f using $rawdata\b1_ks1, clear  
bys hhid12 id_ks1f: keep if _n==_N 
format ks02 ks03 %12.0f  

replace ks02=.m if ks02>=999995 
replace ks03=.m if ks03>=999995 

compress  

sort hhid12  

* III.2. Reshape b1_ks1.dta from long to wide  
****************************************************************************  
reshape wide ks02 ks03, i(hhid12) j(id_ks1f) string  

aorder  
sort hhid12 
save $dir0\b1_ks1_eastwide, replace  
compress  

* III.3. Merge with kecamatan ID, etc  
****************************************************************************  
use $dir0\sc_east, clear  
sort hhid12  
merge 1:1 hhid12 using $dir0\b1_ks1_eastwide  
tab _merge  
keep if _merge==3  
drop _merge  

* III.4. Generate median variables  
****************************************************************************  
for var ks*: egen medcomX=median(X), by(commid12)  
for var ks*: egen medkecX=median(X), by(kecid)  
for var ks*: egen medkabX=median(X), by(kabid)  

* III.5. Imputation  
****************************************************************************  
for var ks*: gen origX=X  

for var ks*: replace X=origX if origX!=.  
for var ks02*: replace X=medcomX if X==.  
for var ks02*: replace X=medkecX if X==.  
for var ks02*: replace X=medkecX if n_comm==1  
for var ks02*: replace X=medkabX if X==.  
for var ks02*: replace X=medkabX if n_kec==1  


for var ks03*: replace X=medcomX if X==. 
for var ks03*: replace X=medkecX if X==. 
for var ks03*: replace X=medkecX if n_comm==1 & X==. 
for var ks03*: replace X=medkabX if X==. 
for var ks03*: replace X=medkabX if n_kec==1 & X==. 

for var ks*: replace X=medcomX if origX==. & X==.  



* III.6. Generate total  
********************************************************************** 

gen sumks02=ks02A+ks02AA+ks02B+ks02BA+ks02C+ks02CA+ks02D+ks02DA+ks02E+ks02EA+ks02F+ks02FA+ks02G+ks02GA /* 
*/ +ks02H+ ks02HA+ks02I+ks02IA+ks02IB+ ks02J+ks02K+ks02L+ks02M+ks02N+ks02OA+ks02OB+ks02P+ks02Q+ks02S /* 
*/ +ks02R+ks02T+ks02U+ks02V+ks02W+ks02X+ks02Y+ks02Z  

gen sumks03=ks03A+ks03AA+ks03B+ks03BA+ks03C+ks03CA+ks03D+ks03DA+ks03E+ks03EA+ks03F+ks03FA+ks03G+ks03GA /*   
*/ +ks03H+ ks03HA+ ks03I+ ks03IA+ks03IB+ ks03J+ks03K+ks03L+ks03M+ks03N+ks03OA+ks03OB+ks03P+ks03Q+ks03S /* 
*/ +ks03R+ks03T+ks03U+ks03V+ks03W+ks03X+ks03Y+ks03Z  


* III.7 Generate variable containing information on missing values in this data file   
**************************************************************************** 
capture drop missks02  
capture drop missks03  
gen missks02=(sumks02==.)  
gen missks03=(sumks03==.)  

lab var missks02 "Household w/ at least 1 KS02 missing"  
lab var missks03 "Household w/ at least 1 KS03 missing"  

tab1 miss*  

* III.8 Label, sort, save the data  
****************************************************************************  
sort hhid12   
capture drop med* origk* sum*  
compress  
label data "Wide version of b1_ks1, with imputation"  
save $dir0\b1_ks1_east, replace  

********************************************************************************  
* IV. KS06 (B1_KS2.DTA)  
********************************************************************************  

* IV.1 Identify outliers  
****************************************************************************  

use hhid12 id_ks1nf ks06 using $rawdata\b1_ks3, clear  
bys hhid12 id_ks1nf: keep if _n==_N 
format ks06 %16.0f 
replace ks06=.m if ks06>=99999995 

sort hhid12  
compress  

* IV.2. Generate variable containing information on missing values in this data file   
****************************************************************************  
gen   x=1 if ks06==.  
replace x=0 if id_ks1nf=="F2"  
replace x=0 if x==.   
egen   missks06=max(x), by(hhid12)  
lab var missks06 "Household w/ at least 1 KS06 missing, excl. F2"  
compress  
drop x  

* IV.3. Reshape b1_ks2.dta from long to wide  
****************************************************************************  
reshape wide ks06, i(hhid12) j(id_ks1nf) string  
tab missks06  
sort hhid12  
compress  
label data "Wide version of b1_ks2"  
save $dir0\b1_ks2_east_wide, replace  
 
* IV.5. Merge with commid, kecid, kabid info  
****************************************************************************  
use hhid12* kecid kabid commid12 n_comm n_kec rural using $dir0\sc_east, clear  
sort hhid12  
merge 1:1 hhid12 using $dir0\b1_ks2_east_wide  
tab _merge  
*Only keep HHs which answered Book 1  
keep if _merge==3  
drop _merge  

inspect ks06*  

* IV.5. Generate median variables  
****************************************************************************  
for var ks*:  egen medcomX=median(X), by(commid12)  
for var ks*:  egen medkecX=median(X), by(kecid)  
for var ks*:  egen medkabX=median(X), by(kabid)  

compress   

* IV.6. Imputation  
****************************************************************************  

for var ks*: gen origX=X  
for var ks*: replace X=medcomX if X==.  
for var ks*: replace X=medkecX if X==. 
for var ks*: replace X=medkecX if n_comm==1 & X==. 
for var ks*: replace X=medkabX if X==. 
for var ks*: replace X=medkabX if n_kec==1 & X==. 

for var ks06*: replace X=medcomX if origX==. & X==.  

replace ks06F2=2000000 if ks06F2>2000000



* IV.7 Generate variable containing information on missing values in this data file   
****************************************************************************  
capture drop missks06 
gen ks06A=ks06A1+ks06A2+ks06A3+ks06A4  
gen sumks06=ks06A+ks06B+ks06C+ks06C1+ks06D+ks06E+ks06F1+ks06G  
gen missks06=(sumks06==.)  
lab var missks06 "Household w/ at least 1 KS06 missing -excluding F2"  
tab missks06  

* IV.8. save the data 
****************************************************************************  
compress  
capture drop origk* med* sumks  
sort hhid12 
save $dir0\b1_ks2_east, replace  
keep hhid12 ks06* 
tempfile 4 
save `4' 

********************************************************************************  
* V. KS08, KS09a,  (B1_KS3.DTA)  
********************************************************************************  
* V.1. Identify outliers  
****************************************************************************  
use ks08 ks09a id_ks2nf hhid12 using $rawdata\b1_ks4, clear  
bys hhid12 id_ks2nf: keep if _n==_N 
replace ks08=.m if ks08>=99999995 
replace ks09a=.m if ks09a>=99999995 

reshape wide ks08 ks09a, i(hhid12) j(id_ks2nf) string
drop ks09aE ks09aG 
order ks08* ks09a*

sort hhid12  

compress  


*replacing extreme values 
replace ks08A=10000000 if ks08A>10000000 
replace ks08B=10000000 if ks08B>10000000 
replace ks08C=15000000 if ks08C>15000000 
replace ks08D=15000000 if ks08D>15000000 
replace ks08E=10000000 if ks08E>10000000 
*ks08F: do nothing 
replace ks08G=20000000 if ks08G>20000000 
*ks09a* : also do nothing because none of their extreme values are above those in ks08


compress  

*V.2. Reshape b1_ks3.dta from long to wide  
****************************************************************************  
sort hhid12   
compress  
label data "Wide version of b1_ks3 created pre_pce.do"  
save $dir0\b1_ks3_east_wide, replace  

*V.3 Merge with kecamatan ID information  
****************************************************************************  

use $dir0\b1_ks3_east_wide, clear  
sort hhid12  
save $dir0\tempks3_east, replace  

use hhid12 commid12 n_comm n_kec kecid kabid rural using $dir0\sc_east, clear  
sort hhid12  
merge 1:1 hhid12 using $dir0\tempks3_east  
tab _merge  
*Only keep HHs which answered Book 2  
keep if _merge==3  
drop _merge  

inspect ks*  

*V.4 Generate median variables  
****************************************************************************  
for var ks*: egen medcomX=median(X), by(commid12)  
for var ks*: egen medkecX=median(X), by(kecid)  
for var ks*: egen medkabX=median(X), by(kabid)  

*V.5. Imputation  
****************************************************************************  
for var ks*: gen origX=X  
for var ks08*: replace X=medcomX if X==. 
for var ks08*: replace X=medkecX if X==. 
for var ks08*: replace X=medkecX if n_comm==1 & X==. 
for var ks08*: replace X=medkabX if X==. 
for var ks08*: replace X=medkabX if n_kec==1 & X==. 

for var ks09*: replace X=medcomX if X==. 
for var ks09*: replace X=medkecX if X==. 
for var ks09*: replace X=medkecX if n_comm==1 & X==. 
for var ks09*: replace X=medkabX if X==. 
for var ks09*: replace X=medkabX if n_kec==1 & X==.  

for var ks08* ks09*: replace X=medcomX if origX==. & X==.  


inspect ks*  

compress   
sort hhid12  

* V.6 Generate variable containing information on missing values in this data file   
****************************************************************************  
gen sumks08=ks08A+ks08B+ks08C+ks08D+ks08E+ks08F+ks08G  
capture drop missks08  
gen missks08=(sumks08==.)  

gen sumks09=ks09aA+ks09aB+ks09aC+ks09aD+ks09aF  
capture drop missks09  
gen missks09=(sumks09==.)  

*V.7. save the data  
****************************************************************************  
lab var  missks08 "Household w/ at least 1 KS08 missing"  
lab var  missks09 "Household w/ at least 1 KS09a missing"  
tab1 miss*  
capture drop med* origk* sum*  
compress  
sort hhid12  

save $dir0\b1_ks3_east, replace  

********************************************************************************  
* VI. B1_KS0  
********************************************************************************  
use  hhid12 ks04b ks07a ks10aa ks10ab ks11aa ks11ab ks12aa ks12ab ks12bb using $rawdata\b1_ks2, clear  
bys hhid12: keep if _n==_N 

replace ks04b=.m if ks04b>=999995 
replace ks07a=.m if ks07a>=99999995 

 
for var ks10* ks11* ks12*: replace X=. if X>=98998998

sort hhid12  

*replacing extreme values
replace ks10aa=15000000 if ks10aa>15000000 
replace ks11aa=. if ks11aa==20600000 
replace ks12aa=20000000 if ks12aa>20000000

merge 1:1 hhid12 using $dir0\sc_east  
tab _merge  
keep if _merge==3  
drop _merge  
 
* VI.1. Identify outliers  
********************************************************************************  
/*gen byte _outlierks0=0   
lab var _outlierks0 "Any outlier in ks0.dta"  
tab _outlierks0 */ 

* VI.2. Generate median variables  
********************************************************************************  
for var ks*: egen medcomX=median(X), by(commid12)  
for var ks*: egen medkecX=median(X), by(kecid)  
for var ks*: egen medkabX=median(X), by(kabid) 

* VI.3. Imputation  
********************************************************************************  
for var ks*: gen origX=X  
for var ks*: replace X=medcomX if X==. 
for var ks*: replace X=medkecX if X==. 
for var ks*: replace X=medkecX if n_comm==1 & X==. 
for var ks*: replace X=medkabX if X==. 
for var ks*: replace X=medkabX if n_kec==1 & X==. 
 
for var ks07a* ks10* ks1* : replace X=medcomX if origX==. & X==.  




* VI.4 Generate variable containing information on missing values in this data file  
********************************************************************************  
gen miss4b=1 if ks04b==.  
lab var miss4b "Household with missing ks04b"  
mvencode miss4b, mv(0)  
tab miss4b  

gen miss7a=1 if ks07a==.  
lab var miss7a "Household with missing ks07a"  
mvencode miss7a, mv(0)  
tab miss7a  

gen miss10aa=1 if ks10aa==.  
lab var miss10aa "Household with missing ks10aa"  
mvencode miss10aa, mv(0)  
tab miss10aa  

gen miss10ab=1 if ks10ab==.  
lab var miss10ab "Household with missing ks10ab"  
mvencode miss10ab, mv(0)  
tab miss10ab  

gen miss11aa=1 if ks11aa==.  
lab var miss11aa "Household with missing ks11aa"  
mvencode miss11aa, mv(0)  
tab miss11aa  

gen miss11ab=1 if ks11ab==.  
lab var miss11ab "Household with missing ks11ab"  
mvencode miss11ab, mv(0)  
tab miss11ab  

gen miss12aa=1 if ks12aa==.  
lab var miss12aa "Household with missing ks12aa"  
mvencode miss12aa, mv(0)  
tab miss12aa  

gen miss12ab=1 if ks12ab==.  
lab var miss12ab "Household with missing ks12ab"  
mvencode miss12ab, mv(0)  
tab miss12ab  

gen miss12bb=1 if ks12bb==.  
lab var miss12bb "Household with missing ks12bb"  
mvencode miss12bb, mv(0)  
tab miss12bb  

* VI.5 save the file  
************************************************************************************  
capture drop  med* origk*  
sort hhid12   
compress   
label data "Shorter version of b1_ks0 created using pre_pce.do"  
save $dir0\b1_ks0_east, replace  

************************************************************************************  
* VII. MERGE ALL EXPENDITURE FILES  
************************************************************************************  
use $dir0\b1_ks0_east, clear  
merge 1:1 hhid12  using $dir0\b1_ks1_east  
tab _merge  
rename _merge _m1  
sort hhid12   
merge 1:1 hhid12  using $dir0\b1_ks2_east  
tab _merge  
rename _merge _m2   
sort hhid12   
merge 1:1 hhid12  using $dir0\b1_ks3_east  
tab _merge  
rename _merge _m3  
sort hhid12   
merge 1:1 hhid12  using $dir0\b2_kr_east  
tab _merge  
* _merge=1 hh in Book 1-KS but not in Book 2 - KR  
* _merge=2 hh in Book 2-KR but not in Book 1 - KS  
list hhid12  _merge if _merge!=3  
keep if _merge==3  
rename _merge _mkr  

gen z=missks02+missks03+missks06+miss4b+miss7a+missks08+missks09+misskr+miss10aa+miss10ab+miss11aa+miss11ab+miss12aa+miss12ab+miss12bb  
gen missing=1 if z>0 & z!=. 
replace missing=1 if z==.   
replace missing=0 if missing==. & z!=.  
replace missing=1 if z==. 

drop z   
lab var missing "Household with at least 1 part of expenditure missing"  
tab missing, m  
lab data "Merged Book1/KS with missing value & outlier information. Wide version"  
save $dir0\pre_pce_ifle.dta, replace  


******************************************************************************  
*VIII. PCE    
******************************************************************************  
use $dir0\pre_pce_ifle,clear  
**FOOD (KS02, KS03, AND KS04B), MONTHLY  

gen mrice=ks02A*52/12  
gen mstaple=(ks02A+ks02B+ks02C+ks02D+ks02E)*52/12   
gen mvege=(ks02F+ks02G+ks02H)*52/12  
gen mdried=(ks02I+ks02J)*52/12  	 
gen mmeat=(ks02K+ks02L+ks02OA+ks02OB)*52/12   
gen mfish=(ks02M+ks02N)*52/12  
gen mdairy=(ks02P+ks02Q)*52/12   
gen mspices=(ks02R+ks02S+ks02T+ks02U+ks02V)*52/12  
gen msugar=(ks02W+ks02AA)*52/12   
gen moil=(ks02X+ks02Y)*52/12  
gen mbeve=(ks02Z+ks02BA+ks02CA+ks02DA+ks02EA)*52/12   
gen maltb=(ks02FA+ks02GA+ks02HA)*52/12   
gen msnack=(ks02IA)*52/12  
gen mfdout=(ks02IB)*52/12  

gen irice=ks03A*52/12  
gen istaple=(ks03A+ks03B+ks03C+ks03D+ks03E)*52/12   
gen ivege=(ks03F+ks03G+ks03H)*52/12  
gen idried=(ks03I+ks03J)*52/12   
gen imeat=(ks03K+ks03L+ks03OA+ks03OB)*52/12   
gen ifish=(ks03M+ks03N)*52/12  
gen idairy=(ks03P+ks03Q)*52/12   
gen ispices=(ks03R+ks03S+ks03T+ks03U+ks03V)*52/12  
gen isugar=(ks03W+ks03AA)*52/12   
gen ioil=(ks03X+ks03Y)*52/12  
gen ibeve=(ks03Z+ks03BA+ks03CA+ks03DA+ks03EA)*52/12   
gen ialtb=(ks03FA+ks03GA+ks03HA)*52/12   
gen isnack=(ks03IA)*52/12  
gen ifdout=(ks03IB)*52/12  
 
gen xrice=mrice+irice  
gen xstaple=mstaple+istaple  
gen xvege=mvege+ivege  
gen xdried=mdried+idried  
gen xmeat=mmeat+imeat  
gen xfish=mfish+ifish  
gen xdairy=mdairy+idairy  
gen xspices=mspices+ispices   
gen xsugar=msugar+isugar  
gen xoil=moil+ioil  
gen xbeve=mbeve+ibeve  
gen xaltb=maltb+ialtb  
gen xsnack=msnack+isnack  
gen xfdout=mfdout+ifdout   

*TOTAL MONTHLY  

*mfood: total ks02  
gen mfood =mstaple+mvege+mdried+mmeat+mfish+mdairy+mspices+msugar+moil+mbeve+maltb+msnack+mfdout  

*ifood: total ks03  
gen ifood =istaple+ivege+idried+imeat+ifish+idairy+ispices+isugar+ioil+ibeve+ialtb+isnack+ifdout  

*xfdtout: Food transfer, ks04b  
gen xfdtout=ks04b*52/12  
lab var xfdtout "Monthly food transfer, ks04b"  

******************************************************************  
*MONTHLY EXPENDITURE ON FOOD: KS02 AND KS03 (NOT INCLUDING KS04B) 
*****************************************************************  
gen xfood =xstaple+xvege+xdried+xmeat+xfish+xdairy+xspices+xsugar+xoil+xbeve+xaltb+xsnack+xfdout  
lab var xfood "Monthly food consumption, ks02 and ks03"  

lab var mrice "Monthly food consumption ks02: rice"   
lab var mstaple "Monthly food consumption ks02: staple"   
lab var mvege "Monthly food consumption ks02: vegetable, fruit"  
lab var mdried "Monthly food consumption ks02: dried food"  
lab var mmeat "Monthly food consumption ks02: meat"  
lab var mfish "Monthly food consumption ks02: fish"  
lab var mdairy "Monthly food consumption ks02: dairy"  
lab var mspices "Monthly food consumption ks02: spices"  
lab var msugar "Monthly food consumption ks02: sugar"  
lab var moil "Monthly food consumption ks02: oil"   
lab var mbeve "Monthly food consumption ks02: beverages"  
lab var maltb "Monthly food consumption ks02: alcohol/tobacco"  
lab var msnack "Monthly food consumption ks02: snacks"  
lab var mfdout "Monthly food consumption ks02: food out of home"  

lab var irice "Monthly food consumption ks03: rice"  
lab var istaple "Monthly food consumption ks03: staple"   
lab var ivege "Monthly food consumption ks03: vegetable, fruit"  
lab var idried "Monthly food consumption ks03: dried food"  
lab var imeat "Monthly food consumption ks03: meat"  
lab var ifish "Monthly food consumption ks03: fish"  
lab var idairy "Monthly food consumption ks03: dairy"  
lab var ispices "Monthly food consumption ks03: spices"  
lab var isugar "Monthly food consumption ks03: sugar"  
lab var ioil "Monthly food consumption ks03: oil"   
lab var ibeve "Monthly food consumption ks03: beverages"  
lab var ialtb "Monthly food consumption ks03: alcohol/tobacco"  
lab var isnack "Monthly food consumption ks03: snacks"  
lab var ifdout "Monthly food consumption ks03: food out of home"  

lab var xrice "Monthly food consumption ks02+ks03: rice"   
lab var xstaple "Monthly food consumption ks02+ks03: staple"   
lab var xvege "Monthly food consumption ks02+ks03: vegetable, fruit"  
lab var xdried "Monthly food consumption ks02+ks03: dried food"  
lab var xmeat "Monthly food consumption ks02+ks03: meat"  
lab var xfish "Monthly food consumption ks02+ks03: fish"  
lab var xdairy "Monthly food consumption ks02+ks03: dairy"  
lab var xspices "Monthly food consumption ks02+ks03: spices"  
lab var xsugar "Monthly food consumption ks02+ks03: sugar"  
lab var xoil "Monthly food consumption ks02+ks03: oil"   
lab var xbeve "Monthly food consumption ks02+ks03: beverages"  
lab var xaltb "Monthly food consumption ks02+ks03: alcohol/tobacco"  
lab var xsnack "Monthly food consumption ks02+ks03: snacks"  
lab var xfdout "Monthly food consumption ks02+ks03: food out of home"  

lab var mfood "Monthly food cons.,market purch. all ks02"  
lab var ifood "Monthly food cons.,own-prod. all ks03"  


*END OF FOOD  

* NON-FOOD FROM id_ks1nf (KS06), MONTHLY  

rename ks06A xutility  
rename ks06B xpersonal  
rename ks06C xhhgood  
rename ks06C1 xdomest  
rename ks06D xrecreat  
rename ks06E xtransp  
rename ks06F1 xlottery  
rename ks06F2 xarisan  
rename ks06G xtransf2  

lab var xutility "Monthly expend. on utility ks06A"  
lab var xpersonal "Monthly expend. on personal goods ks06B"  
lab var xhhgood "Monthly expend. on hh goods ks06C"  
lab var xdomest "Monthly expend. on domestic goods ks06C1"  
lab var xrecreat "Monthly expend. on recreation ks06D"  
lab var xtransp "Monthly expend. on transport. ks06E"  
lab var xlottery "Monthly expend. on lottery ks06F1"  
lab var xarisan "Monthly expend. on arisan ks06F2"  
lab var xtransf2 "Monthly expend. on transfer ks06G"  

rename ks07a inonfood  
lab var inonfood "Monthly non-food own-produce (ks07a)"  


*xnonfood2 IS ALL KS06 EXCLUDING TRANSFER AND ARISAN   
gen xnonfood2=xutility+xpersonal+xhhgood+xdomest+xrecreat+xtransp+xlottery   

*totks06 IS ALL KS06   
gen totks06=xnonfood2+xtransf2+xarisan  

lab var xnonfood2 "Monthly non-food expend. id_ks1nf, transfer & arisan excl."  
lab var totks06 "Monthly non-food expend. id_ks1nf, transfer & arisan incl."  
sort hhid12  

*NON-FOOD FROM id_ks2nf (KS08, KS09A), CONVERTED TO MONTHLY FIGURES  

gen mcloth=ks08A/12  
gen mfurn=ks08B/12  
gen mmedical=ks08C/12  
gen mcerem=ks08D/12  
gen mtax=ks08E/12  
gen mother=ks08F/12  
gen mtransf3=ks08G/12  

gen icloth=ks09aA/12  
gen ifurn=ks09aB/12  
gen imedical=ks09aC/12  
gen icerem=ks09aD/12  
gen iother=ks09aF/12  

gen xcloth=mcloth+icloth  
gen xfurn=mfurn+ifurn  
gen xmedical=mmedical+imedical  
gen xcerem=mcerem+icerem  
gen xtax=mtax  
gen xother=mother+iother  
gen xtransf3=mtransf3  
	
*xnonfood3 IS ALL KS08 and KS09a EXCLUDING TRANSFER   
gen xnonfood3=xcloth+xfurn+xmedical+xcerem+xtax+xother   

lab var mcloth "Monthly non-food expend: clothing,ks08A"  
lab var mfurn "Monthly non-food expend: furniture,ks08B"  
lab var mmedical "Monthly non-food expend: medical,ks08C"  
lab var mcerem "Monthly non-food expend: ceremony,ks08D"  
lab var mtax "Monthly non-food expend: tax,ks08E"  
lab var mother "Monthly non-food expend: other,ks08F"  
lab var mtransf3 "Monthly non-food expend: transfer,ks08G"  

lab var icloth "Monthly non-food expend: clothing,ks09aA"  
lab var ifurn "Monthly non-food expend: furniture,ks09aB"  
lab var imedical "Monthly non-food expend: medical,ks09aC"  
lab var icerem "Monthly non-food expend: ceremony,ks09aD"  
lab var iother "Monthly non-food expend: other,ks09aF"  

lab var xcloth "Monthly non-food expend: clothing,ks08A+ks09aA"  
lab var xfurn "Monthly non-food expend: furniture,ks08B+ks09aB"  
lab var xmedical "Monthly non-food expend: medical,ks08C+ks09aC"  
lab var xcerem "Monthly non-food expend: ceremony,ks08D+ks09aD"  
lab var xtax "Monthly non-food expend: tax,ks08E"  
lab var xother "Monthly non-food expend: other,ks08F+ks09aF"  
lab var xtransf3 "Monthly non-food expend: transfer,ks08G"  

lab var xnonfood3 "Monthly non-food expend. id_ks2nf(all ks08,ks09a excl. ks08G)"  


**HOUSING  

gen xhrent=kr04 if kr04ax!=.  
gen xhown=kr05 if kr05ax!=.  
gen xhouse=kr04 if kr04ax!=.  
replace xhouse=kr05 if kr05ax!=.  

lab var xhrent "Monthly expend. on housing:rent (kr04)"  
lab var xhown "Monthly expend. on housing:own  (kr05)"  
lab var xhouse "Monthly expend. on housing (kr04/kr05)"   

********  
*EDUCATION  

gen xedutuit=ks10aa/12  
gen xeduunif=ks11aa/12  
gen xedutran=ks12aa/12  
gen xeduc=xedutuit+xeduunif+xedutran  
gen xedutuitout=ks10ab/12  
gen xeduunifout=ks11ab/12  
gen xedutranout=ks12ab/12  
gen xedubordout=ks12bb/12  
gen xeducout=xedutuitout+xeduunifout+xedutranout+xedubordout  
gen xeducall=xeduc+xeducout  

lab var xedutuit "Monthly expend. on educ.:tuition, ks10aa"  
lab var xeduunif "Monthly expend. on educ.:uniform, ks11aa"  
lab var xedutran "Monthly expend. on educ.:transport, ks12aa"  
lab var xedutuitout "Monthly expend. on educ. out of home:tuition, ks10ab"  
lab var xeduunifout "Monthly expend. on educ. out of home:uniform, ks11ab"  
lab var xedutranout "Monthly expend. on educ. out of home:transport, ks12ab"  
lab var xedubordout "Monthly expend. on educ. out of home:boarding, ks12bb"  
lab var xeduc "Monthly expend. on educ ks10aa-ks12aa"  
lab var xeducout "Monthly expend. on educ, out of home ks10ab-ks12bb"  
lab var xeducall "Monthly expend. on educ, all (ks10aa-ks12bb)"  

*NOTE: FOR CALCULATING HH EXPENDITURE, USE XEDUC (EXPEND. ON KIDS INSIDE THE HOME)   

*********************************  
*MONTHLY EXPENDITURE CATEGORIES  
******************************  

drop ks02* ks03*  

***************************************  
* HOUSEHOLD EXPENDITURE: XFOOD + XNONFOOD  
***************************************  

**FOOD : xfood: total of KS02 and KS03, already generated   

**NONFOOD:xnonfood=xnonfood2+xnonfood3+xhousing+xeduc+inonfood,  
*SO IT IS THE TOTAL OF KS06 WITHOUT ARISAN + TOTAL KS08,KS09 + HOUSING + EDUCATION FOR CHILDREN IN THE HOME ONLY + OWN-PRODUCED NON0-FOOD.  
*ks06 w/o arisan, ks08, ks09a, ks10aa-ks12aa, ks07a). Generated below:  

gen xnonfood=xnonfood2+xnonfood3+xhouse+xeduc+inonfood  
lab var xnonfood "Monthly non-food expenditure"   

** HHEXP: MONTHLY HOUSEHOLD EXPENDITURE   
gen hhexp=xfood+xnonfood  
lab var hhexp "Monthly expenditure"  
inspect hhexp  


**********************************  
*OTHER CATEGORIES  
**************************************  

*MONTHLY FOOD CONSUMPTION: FROM KS02,KS03 AND TRANSFER OF FOOD OUT  
gen hhfood=xfood+xfdtout  
lab var hhfood "Monthly consumption on food (ks02,ks03 AND ks04b)"  

*MONTHLY TRANSFER: FROM KS04B, KS06G, KS8G, AND EDUC FOR KID OUTSIDE THE HOME monthly  
gen xtransfer=xfdtout+xtransf2+xtransf3+xeducout  
lab var xtransfer "Monthly transfer (from ks04b,ks6G,ks08G,ks10ab-ks12bb)"  

*MONTHLY EXPENDITURES ON HOUSEHOLD EXPENSES   
gen xhhx=xutility+xhhgood+xdomest+xfurn  
lab var xhhx "Monthly expend. on household expenses"  

*MONTHLY EXPENDITURES ON TRANSPORTATION: xtransp (already generated)  

*MONTHLY EXPENDITURES ON MEDICAL: xmedical (already generated)  

*MONTHLY EXPENDITURES ON ENTERTAINMENT  
gen xentn=xrecreat+xlottery+xcerem  
lab var xentn "Monthly expend. on entertainment"  

*MONTHLY EXPENDITURES ON DURABLES  
gen xdura=xfurn+xother+xtransf3   
lab var xdura "Monthly expend. on durables"  

*MONTHLY EXPENDITURES ON CEREMONIES AND TAX  
gen xritax=xcerem+xtax  
lab var xritax "Monthly expend. on ritual and tax"  

sort hhid12  
drop ks0*   
compress  
save $dir0\pce_ifle_wo_hhsize.dta, replace  


**************************************************************************************************** 
* IX. MERGE WITH HHSIZE.DTA,  DATA FROM AR WITH INFO ON HHSIZE (AR01==1 OR 5) 
*************************************************************************************************   
use hhid12 hhsize using $rawdata\bk_ar0, clear  
sort hhid12  
save $dir0\hhsize_east, replace  

merge 1:1 hhid12 using $dir0\pce_ifle_wo_hhsize.dta  
lab var _merge "Expenditure available?"  
lab val _merge _mexp 
lab define _mexp 1 "1.Roster only" 2 "2.Expend only" 3 "3.Yes"  
tab _merge   
*keep if _merge==3  
tab missing _merge, m  
tab _mkr _merge, m  
rename _merge _mexp 

inspect hhexp   
inspect hhsize  

*PER CAPITA EXPENDITURES: HHEXP/HHSIZE 
gen pce=hhexp/hhsize  
lab var pce "Per capita expenditure"  

inspect pce  
sum pce, detail  
sum pce if missing==0 , detail  

gen lnpce=log(pce)  
lab var lnpce "Log of per capita expenditure"  


**EXPENDITURE SHARES:  EXPEND. x 100 / HHEXP  

gen wrice=xrice*100/hhexp  
gen wstaple=xstaple*100/hhexp  
gen wvege=xvege*100/hhexp  
gen wfood=xfood*100/hhexp  
gen woil=xoil*100/hhexp	  
gen wmedical=xmedical*100/hhexp  
gen wcloth=xcloth*100/hhexp  
gen wdairy=xdairy*100/hhexp  
gen weducall=xeducall*100/hhexp  
gen whous=xhous*100/hhexp  
gen wmtfs=(xmeat+xfish)*100/hhexp  
gen wnonfood=xnonfood*100/hhexp  
gen waltb=xaltb*100/hhexp  

lab var wrice "Expend. share: rice"  
lab var wstaple "Expend. share: staple food"  
lab var wvege "Expend. share: vegetable"  
lab var woil "Expend. share: oil"  
lab var waltb "Expend. share: alcohol+tobacco"  
lab var wfood "Expend. share: food"  

lab var wmedical "Expend. share: medical cost"  
lab var wcloth "Expend. share: clothing"  
lab var wdairy "Expend. share: dairy"  
lab var weducall "Expend. share: education (all)"  
lab var whous "Expend. share: housing"  
lab var wmtfs "Expend. share: meat+fish"  
lab var wnonfood "Expend. share: nonfood excl.arisan"  

compress  
tab1 miss*, m 

drop sc* kabid kecid 
sort hhid12 
merge 1:1 hhid12 using $dir0\sc_east 
rename _merge _msc 
capture drop provid_east 
gen provid_east=sc01 
keep hhid12 commid12 prov* kabid kecid x* m* i* w* hh* *pce hhsize owners  _mexp  _msc sc05 

gen rural=(sc05!=1) 

for var miss*: replace X=1 if X==. 

rename provid_east provid 
lab var provid "Province ID" 
lab var kabid "Kabupaten ID" 
lab var kecid "Kecamatan ID" 
lab var rural "Urban=0 Rural=1" 

compress 

tab1 miss*, m

keep hhid12 commid12 prov kabid kecid x* m* i* w* hh* *pce hhsize owners
drop miss*

lab data "Per Capita Expenditure IFLS East"  
sort hhid12  

merge 1:1 hhid12 using "$rawdata\htrack.dta" 
keep if _merge==1 | _merge==3 
drop _merge 

tempfile weight 
save `weight' 


use hhid12 sc01 sc05 using "$rawdata\bk_sc.dta", clear 
rename sc01 id_prov
rename sc05 id_area
merge 1:1 hhid12 using `weight' 
drop _merge 
merge m:1 id_prov id_area using "$external\IDN_povline_2012.dta"	// 2012 National Poverty Line dataset 
keep if _merge==3 
drop _merge

levelsof povline if id_prov==81 & id_area==1, local(base)
la var povline "Rural/urban provincial poverty lines from BPS for September 2012"
cap gen pricedef=povline/`base'
la var pricedef "Ratio of BPS poverty lines September 2012, base=Maluku Urban"
gen realpce=pce/pricedef 
la var realpce "Real household per-capita expenditures (pce / pricedef), (monthly)"
la var pricedef "Ratio of BPS poverty lines September 2012, base=Maluku Urban"
la var hhexp "Household Expenditure (monthly)"
la var pce "Household per-capita expenditure (monthly)"
la var hhfood "Household consumption expenditure on food (ks02, ks03, ks04b) (monthly)"
la var xnonfood "Household consumption expenditures on non-food items (monthly)"
gen missing=(realpce==.)
la var missing "Missing due to unreliable/unclear response in at least one expenditure component"



order hhid12 commid12 kabid kecid id_area hhsize
order hhexp pce hhfood xnonfood povline pricedef realpce hwt, last

saveold "$rawdata\percapita_expenditure_iflse2012.dta", replace
